/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.bridge.paper.dialog;

import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.body.ItemDialogBody;
import io.papermc.paper.registry.data.dialog.body.PlainMessageDialogBody;
import io.papermc.paper.registry.data.dialog.input.BooleanDialogInput;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.input.NumberRangeDialogInput;
import io.papermc.paper.registry.data.dialog.input.SingleOptionDialogInput;
import io.papermc.paper.registry.data.dialog.input.TextDialogInput;
import io.papermc.paper.registry.data.dialog.type.ConfirmationType;
import io.papermc.paper.registry.data.dialog.type.DialogListType;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import io.papermc.paper.registry.data.dialog.type.MultiActionType;
import io.papermc.paper.registry.data.dialog.type.NoticeType;
import io.papermc.paper.registry.data.dialog.type.ServerLinksType;
import io.papermc.paper.registry.set.RegistrySet;
import io.papermc.paper.registry.set.RegistryValueSet;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.bridge.common.NightNbtHolder;
import su.nightexpress.nightcore.bridge.dialog.adapter.DialogActionAdapter;
import su.nightexpress.nightcore.bridge.dialog.adapter.DialogAdapter;
import su.nightexpress.nightcore.bridge.dialog.adapter.DialogBaseAdapter;
import su.nightexpress.nightcore.bridge.dialog.adapter.DialogBodyAdapter;
import su.nightexpress.nightcore.bridge.dialog.adapter.DialogButtonAdapter;
import su.nightexpress.nightcore.bridge.dialog.adapter.DialogInputAdapter;
import su.nightexpress.nightcore.bridge.dialog.adapter.DialogTypeAdapter;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.action.WrappedDialogAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.action.WrappedDialogCommandTemplateAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.action.WrappedDialogCustomAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.action.WrappedDialogStaticAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.base.WrappedDialogAfterAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.base.WrappedDialogBase;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedItemDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedPlainMessageDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedBooleanDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedNumberRangeDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.single.WrappedSingleOptionDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.single.WrappedSingleOptionEntry;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.text.WrappedMultilineOptions;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.text.WrappedTextDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedConfirmationType;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogListType;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedMultiActionType;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedNoticeType;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedServerLinksType;
import su.nightexpress.nightcore.bridge.paper.PaperBridge;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.bridge.wrapper.NightComponent;
import su.nightexpress.nightcore.util.text.night.NightMessage;

public class PaperDialogAdapter
implements DialogAdapter<Dialog>,
DialogActionAdapter<DialogAction>,
DialogBaseAdapter<DialogBase>,
DialogBodyAdapter<DialogBody>,
DialogButtonAdapter<ActionButton>,
DialogInputAdapter<DialogInput>,
DialogTypeAdapter<DialogType> {
    private final PaperBridge bridge;

    public PaperDialogAdapter(@NotNull PaperBridge bridge) {
        this.bridge = bridge;
    }

    @NotNull
    private Component adaptComponent(@NotNull String component) {
        return this.adaptComponent(NightMessage.parse((String)component));
    }

    @NotNull
    private Component adaptComponent(@NotNull NightComponent component) {
        return this.bridge.getTextComponentAdapter().adaptComponent(component);
    }

    @NotNull
    public Dialog adaptDialog(@NotNull WrappedDialog wrappedDialog) {
        WrappedDialogBase wrappedBase = wrappedDialog.base();
        WrappedDialogType wrappedType = wrappedDialog.type();
        DialogBase base = this.adaptBase(wrappedBase);
        DialogType type = this.adaptType(wrappedType);
        return Dialog.create(factory -> ((DialogRegistryEntry.Builder)factory.empty()).type(type).base(base));
    }

    @NotNull
    public DialogAction adaptAction(@NotNull WrappedDialogAction action) {
        return (DialogAction)action.adapt((DialogActionAdapter)this);
    }

    @NotNull
    public DialogAction.StaticAction adaptAction(@NotNull WrappedDialogStaticAction action) {
        ClickEvent clickEvent = this.bridge.getTextComponentAdapter().adaptClickEvent(action.clickEvent());
        return DialogAction.staticAction((ClickEvent)clickEvent);
    }

    @NotNull
    public DialogAction.CustomClickAction adaptAction(@NotNull WrappedDialogCustomAction action) {
        NightNbtHolder nbtHolder = action.nbt();
        BinaryTagHolder additions = nbtHolder == null ? null : BinaryTagHolder.binaryTagHolder((String)nbtHolder.asString());
        return DialogAction.customClick((Key)Key.key((String)"nightcore_dialogs", (String)action.id()), (BinaryTagHolder)additions);
    }

    @NotNull
    public DialogAction.CommandTemplateAction adaptAction(@NotNull WrappedDialogCommandTemplateAction action) {
        return DialogAction.commandTemplate((String)action.template());
    }

    @NotNull
    private DialogBase.DialogAfterAction adaptAfterAction(@NotNull WrappedDialogAfterAction action) {
        return switch (action) {
            default -> throw new MatchException(null, null);
            case WrappedDialogAfterAction.NONE -> DialogBase.DialogAfterAction.NONE;
            case WrappedDialogAfterAction.CLOSE -> DialogBase.DialogAfterAction.CLOSE;
            case WrappedDialogAfterAction.WAIT_FOR_RESPONSE -> DialogBase.DialogAfterAction.WAIT_FOR_RESPONSE;
        };
    }

    @NotNull
    public DialogBase adaptBase(@NotNull WrappedDialogBase base) {
        Component title = this.adaptComponent(base.title());
        Component externalTitle = base.externalTitle() == null ? null : this.adaptComponent(base.externalTitle());
        boolean canCloseWithEscape = base.canCloseWithEscape();
        boolean pause = base.pause();
        DialogBase.DialogAfterAction afterAction = this.adaptAfterAction(base.afterAction());
        List body = Lists.modify((List)base.body(), this::adaptBody);
        List inputs = Lists.modify((List)base.inputs(), this::adaptInput);
        return DialogBase.create((Component)title, (Component)externalTitle, (boolean)canCloseWithEscape, (boolean)pause, (DialogBase.DialogAfterAction)afterAction, (List)body, (List)inputs);
    }

    @NotNull
    public DialogBody adaptBody(@NotNull WrappedDialogBody body) {
        return (DialogBody)body.adapt((DialogBodyAdapter)this);
    }

    @NotNull
    public ItemDialogBody adaptBody(@NotNull WrappedItemDialogBody body) {
        ItemStack item = body.item();
        WrappedPlainMessageDialogBody description = body.description();
        boolean showDecorations = body.showDecorations();
        boolean showTooltip = body.showTooltip();
        int width = body.width();
        int height = body.height();
        PlainMessageDialogBody desc = description == null ? null : this.adaptBody(description);
        return DialogBody.item((ItemStack)item, (PlainMessageDialogBody)desc, (boolean)showDecorations, (boolean)showTooltip, (int)width, (int)height);
    }

    @NotNull
    public PlainMessageDialogBody adaptBody(@NotNull WrappedPlainMessageDialogBody body) {
        Component contents = this.adaptComponent(body.contents());
        int width = body.width();
        return DialogBody.plainMessage((Component)contents, (int)width);
    }

    @NotNull
    public ActionButton adaptButton(@NotNull WrappedActionButton wrappedButton) {
        WrappedDialogAction wrappedAction = wrappedButton.action();
        Component label = this.adaptComponent(wrappedButton.label());
        Component tooltip = wrappedButton.tooltip() == null ? null : this.adaptComponent(wrappedButton.tooltip());
        DialogAction action = wrappedAction == null ? null : this.adaptAction(wrappedAction);
        int width = wrappedButton.width();
        return ActionButton.create((Component)label, (Component)tooltip, (int)width, (DialogAction)action);
    }

    @NotNull
    public DialogInput adaptInput(@NotNull WrappedDialogInput input) {
        return (DialogInput)input.adapt((DialogInputAdapter)this);
    }

    @NotNull
    public TextDialogInput adaptInput(@NotNull WrappedTextDialogInput input) {
        String key = input.key();
        int width = input.width();
        Component label = this.adaptComponent(input.label());
        boolean labelVisible = input.labelVisible();
        String initial = input.initial();
        int maxLength = input.maxLength();
        WrappedMultilineOptions wrappedMultiline = input.multiline();
        TextDialogInput.MultilineOptions multilineOptions = wrappedMultiline == null ? null : TextDialogInput.MultilineOptions.create((Integer)wrappedMultiline.maxLines(), (Integer)wrappedMultiline.height());
        return DialogInput.text((String)key, (int)width, (Component)label, (boolean)labelVisible, (String)initial, (int)maxLength, (TextDialogInput.MultilineOptions)multilineOptions);
    }

    @NotNull
    private SingleOptionDialogInput.OptionEntry adaptEntry(@NotNull WrappedSingleOptionEntry wrappedEntry) {
        String id = wrappedEntry.id();
        Component display = this.adaptComponent(wrappedEntry.display());
        boolean initial = wrappedEntry.initial();
        return SingleOptionDialogInput.OptionEntry.create((String)id, (Component)display, (boolean)initial);
    }

    @NotNull
    public SingleOptionDialogInput adaptInput(@NotNull WrappedSingleOptionDialogInput input) {
        String key = input.key();
        int width = input.width();
        List entries = Lists.modify((List)input.entries(), this::adaptEntry);
        Component label = this.adaptComponent(input.label());
        boolean labelVisible = input.labelVisible();
        return DialogInput.singleOption((String)key, (int)width, (List)entries, (Component)label, (boolean)labelVisible);
    }

    @NotNull
    public BooleanDialogInput adaptInput(@NotNull WrappedBooleanDialogInput input) {
        String key = input.key();
        Component label = this.adaptComponent(input.label());
        boolean initial = input.initial();
        String onTrue = input.onTrue();
        String onFalse = input.onFalse();
        return DialogInput.bool((String)key, (Component)label, (boolean)initial, (String)onTrue, (String)onFalse);
    }

    @NotNull
    public NumberRangeDialogInput adaptInput(@NotNull WrappedNumberRangeDialogInput input) {
        String key = input.key();
        int width = input.width();
        Component label = this.adaptComponent(input.label());
        String labelFormat = input.labelFormat();
        float start = input.start();
        float end = input.end();
        Float initial = input.initial();
        Float step = input.step();
        return DialogInput.numberRange((String)key, (int)width, (Component)label, (String)labelFormat, (float)start, (float)end, (Float)initial, (Float)step);
    }

    @NotNull
    public DialogType adaptType(@NotNull WrappedDialogType type) {
        return (DialogType)type.adapt((DialogTypeAdapter)this);
    }

    @NotNull
    public ConfirmationType adaptType(@NotNull WrappedConfirmationType type) {
        WrappedActionButton wrappedYes = type.yesButton();
        WrappedActionButton wrappedNo = type.noButton();
        return DialogType.confirmation((ActionButton)this.adaptButton(wrappedYes), (ActionButton)this.adaptButton(wrappedNo));
    }

    @NotNull
    public DialogListType adaptType(@NotNull WrappedDialogListType type) {
        List wrappedDialogs = type.dialogs();
        WrappedActionButton exitAction = type.exitAction();
        int buttonWidth = type.buttonWidth();
        int columns = type.columns();
        List dialogs = Lists.modify((List)wrappedDialogs, this::adaptDialog);
        ActionButton exit = exitAction == null ? null : this.adaptButton(exitAction);
        RegistryValueSet dialogRegistry = RegistrySet.valueSet((RegistryKey)RegistryKey.DIALOG, (Iterable)dialogs);
        return DialogType.dialogList((RegistrySet)dialogRegistry, (ActionButton)exit, (int)columns, (int)buttonWidth);
    }

    @NotNull
    public MultiActionType adaptType(@NotNull WrappedMultiActionType type) {
        List wrappedActions = type.actions();
        WrappedActionButton wrappedExit = type.exitAction();
        List actions = Lists.modify((List)wrappedActions, this::adaptButton);
        ActionButton exitAction = wrappedExit == null ? null : this.adaptButton(wrappedExit);
        int columns = type.columns();
        return DialogType.multiAction((List)actions, (ActionButton)exitAction, (int)columns);
    }

    @NotNull
    public NoticeType adaptType(@NotNull WrappedNoticeType type) {
        WrappedActionButton wrappedAction = type.action();
        ActionButton action = this.adaptButton(wrappedAction);
        return DialogType.notice((ActionButton)action);
    }

    @NotNull
    public ServerLinksType adaptType(@NotNull WrappedServerLinksType type) {
        WrappedActionButton wrappedExit = type.exitAction();
        ActionButton exitAction = wrappedExit == null ? null : this.adaptButton(wrappedExit);
        int columns = type.columns();
        int buttonWidth = type.buttonWidth();
        return DialogType.serverLinks((ActionButton)exitAction, (int)columns, (int)buttonWidth);
    }
}

