/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.wrapper;

import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.BukkitThing;

@Deprecated
public class UniSound {
    private final String soundName;
    private final Sound soundType;
    private final float volume;
    private final float pitch;

    public UniSound(@NotNull String soundName, @Nullable Sound soundType, float volume, float pitch) {
        this.soundName = soundName.toLowerCase();
        this.soundType = soundType;
        this.volume = volume;
        this.pitch = pitch;
    }

    @NotNull
    public static UniSound of(@NotNull Sound sound) {
        return UniSound.of(sound, 0.8f);
    }

    @NotNull
    public static UniSound of(@NotNull Sound sound, float volume) {
        return UniSound.of(sound, volume, 1.0f);
    }

    @NotNull
    public static UniSound of(@NotNull Sound sound, float volume, float pitch) {
        return new UniSound(BukkitThing.toString((Keyed)sound), sound, volume, pitch);
    }

    @NotNull
    public static UniSound read(@NotNull FileConfig cfg, @NotNull String path) {
        String soundName = ConfigValue.create(path + ".Name", "null", "Sound name. You can use Spigot sound names, or ones from your resource pack.", "Spigot Sounds: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/Sound.html").read(cfg);
        float volume = ConfigValue.create(path + ".Volume", 0.8, "Sound volume. From 0.0 to 1.0.").read(cfg).floatValue();
        float pitch = ConfigValue.create(path + ".Pitch", 1.0, "Sound speed. From 0.5 to 2.0").read(cfg).floatValue();
        Sound soundType = BukkitThing.getSound((String)soundName);
        return new UniSound(soundName, soundType, volume, pitch);
    }

    public void write(@NotNull FileConfig cfg, @NotNull String path) {
        cfg.set(path + ".Name", this.getSoundName());
        cfg.set(path + ".Volume", Float.valueOf(this.getVolume()));
        cfg.set(path + ".Pitch", Float.valueOf(this.getPitch()));
    }

    public boolean isEmpty() {
        return this.getVolume() <= 0.0f || this.getSoundName().isEmpty();
    }

    public void play(@NotNull Player player) {
        if (this.isEmpty()) {
            return;
        }
        Location location = player.getLocation();
        if (this.getSoundType() == null) {
            player.playSound(location, this.getSoundName(), this.getVolume(), this.getPitch());
        } else {
            player.playSound(location, this.getSoundType(), this.getVolume(), this.getPitch());
        }
    }

    public void play(@NotNull Location location) {
        if (this.isEmpty()) {
            return;
        }
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        if (this.getSoundType() == null) {
            world.playSound(location, this.getSoundName(), this.getVolume(), this.getPitch());
        } else {
            world.playSound(location, this.getSoundType(), this.getVolume(), this.getPitch());
        }
    }

    @NotNull
    public String getSoundName() {
        return this.soundName;
    }

    @Nullable
    public Sound getSoundType() {
        return this.soundType;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }
}

