/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.text;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.bridge.text.NightAbstractComponent;
import su.nightexpress.nightcore.util.bridge.wrapper.ComponentBuildable;
import su.nightexpress.nightcore.util.bridge.wrapper.NightComponent;
import su.nightexpress.nightcore.util.text.LangNode;
import su.nightexpress.nightcore.util.text.TextNode;
import su.nightexpress.nightcore.util.text.tag.decorator.ColorDecorator;
import su.nightexpress.nightcore.util.text.tag.decorator.Decorator;
import su.nightexpress.nightcore.util.text.tag.decorator.GradientColorDecorator;

@Deprecated
public class TextGroup
implements ComponentBuildable {
    private final String name;
    private final List<ComponentBuildable> childrens;
    private final Set<Decorator> decorators;
    private ColorDecorator colorDecorator;
    private TextGroup parent;

    public TextGroup(@NotNull String name) {
        this.name = name;
        this.childrens = new ArrayList<ComponentBuildable>();
        this.decorators = new LinkedHashSet<Decorator>();
    }

    @NotNull
    public TextGroup createChildren(@NotNull String name) {
        TextGroup group = new TextGroup(name);
        group.parent = this;
        group.colorDecorator = this.colorDecorator;
        group.decorators.addAll(this.decorators);
        this.childrens.add(group);
        return group;
    }

    @NotNull
    public TextNode createNode() {
        TextNode node = new TextNode(this);
        this.childrens.add(node);
        return node;
    }

    @NotNull
    public LangNode createLangNode(@NotNull String key, @Nullable String fallback) {
        LangNode node = new LangNode(this, key, fallback);
        this.childrens.add(node);
        return node;
    }

    public void addDecorator(@NotNull Decorator decorator) {
        if (decorator instanceof ColorDecorator) {
            ColorDecorator color;
            this.colorDecorator = color = (ColorDecorator)decorator;
        } else {
            this.decorators.add(decorator);
        }
    }

    public void clearDecorators() {
        this.colorDecorator = null;
        this.decorators.clear();
    }

    @NotNull
    public NightComponent toComponent() {
        GradientColorDecorator gradientDecorator;
        ColorDecorator colorDecorator = this.colorDecorator;
        if (colorDecorator instanceof GradientColorDecorator && !(gradientDecorator = (GradientColorDecorator)colorDecorator).isCreated()) {
            AtomicInteger length = new AtomicInteger(0);
            this.countLength(this, length);
            gradientDecorator.createGradient(length.get());
        }
        ArrayList children = new ArrayList();
        this.childrens.forEach(buildable -> children.add((NightAbstractComponent)buildable.toComponent()));
        return NightComponent.empty().children(children);
    }

    private void countLength(@NotNull TextGroup parent, @NotNull AtomicInteger length) {
        for (ComponentBuildable buildable : parent.getChildrens()) {
            TextGroup textGroup;
            if (buildable instanceof TextNode) {
                TextNode textNode = (TextNode)buildable;
                length.addAndGet(textNode.textLength());
            }
            if (!(buildable instanceof TextGroup) || (textGroup = (TextGroup)buildable).getColor() != this.colorDecorator) continue;
            this.countLength(textGroup, length);
        }
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public TextGroup getParent() {
        return this.parent;
    }

    @Nullable
    public ColorDecorator getColor() {
        return this.colorDecorator;
    }

    @NotNull
    public Set<Decorator> getDecorators() {
        return this.decorators;
    }

    @NotNull
    public List<ComponentBuildable> getChildrens() {
        return this.childrens;
    }
}

