/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.bukkit.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.util.Enums;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.Pair;
import su.nightexpress.nightcore.util.Strings;
import su.nightexpress.nightcore.util.placeholder.PlaceholderEntry;
import su.nightexpress.nightcore.util.random.Rnd;
import su.nightexpress.nightcore.util.regex.TimedMatcher;
import su.nightexpress.nightcore.util.text.night.NightMessage;

public class StringUtil {
    private static final Pattern ID_PATTERN = Pattern.compile("[<>\\%\\$\\!\\@\\#\\^\\&\\*\\(\\)\\,\\.\\'\\:\\;\\\"\\}\\]\\{\\[\\=\\+\\`\\~\\\\]");
    private static final Pattern ID_STRICT_PATTERN = Pattern.compile("[^a-zA-Z\u0430-\u044f\u0410-\u042f_0-9]");

    @Deprecated
    @NotNull
    public static String oneSpace(@NotNull String str) {
        return str.trim().replaceAll("\\s+", " ");
    }

    @Deprecated
    @NotNull
    public static String noSpace(@NotNull String str) {
        return str.trim().replaceAll("\\s+", "");
    }

    @Deprecated
    @NotNull
    public static String replaceEach(@NotNull String text, @NotNull List<Pair<String, Supplier<String>>> replacements) {
        int tempIndex;
        if (text.isEmpty() || replacements.isEmpty()) {
            return text;
        }
        int searchLength = replacements.size();
        boolean[] noMoreMatchesForReplIndex = new boolean[searchLength];
        int textIndex = -1;
        int replaceIndex = -1;
        for (int i = 0; i < searchLength; ++i) {
            if (noMoreMatchesForReplIndex[i]) continue;
            tempIndex = text.indexOf(replacements.get(i).getFirst());
            if (tempIndex == -1) {
                noMoreMatchesForReplIndex[i] = true;
                continue;
            }
            if (textIndex != -1 && tempIndex >= textIndex) continue;
            textIndex = tempIndex;
            replaceIndex = i;
        }
        if (textIndex == -1) {
            return text;
        }
        int start = 0;
        StringBuilder buf = new StringBuilder();
        while (textIndex != -1) {
            int i;
            for (i = start; i < textIndex; ++i) {
                buf.append(text.charAt(i));
            }
            buf.append(replacements.get(replaceIndex).getSecond().get());
            start = textIndex + replacements.get(replaceIndex).getFirst().length();
            textIndex = -1;
            replaceIndex = -1;
            for (i = 0; i < searchLength; ++i) {
                if (noMoreMatchesForReplIndex[i]) continue;
                tempIndex = text.indexOf(replacements.get(i).getFirst(), start);
                if (tempIndex == -1) {
                    noMoreMatchesForReplIndex[i] = true;
                    continue;
                }
                if (textIndex != -1 && tempIndex >= textIndex) continue;
                textIndex = tempIndex;
                replaceIndex = i;
            }
        }
        int textLength = text.length();
        for (int i = start; i < textLength; ++i) {
            buf.append(text.charAt(i));
        }
        return buf.toString();
    }

    @NotNull
    public static <T> String replaceEach(@NotNull String text, @NotNull List<PlaceholderEntry<T>> replacements, @NotNull T source) {
        int tempIndex;
        if (text.isEmpty() || replacements.isEmpty()) {
            return text;
        }
        int searchLength = replacements.size();
        boolean[] noMoreMatchesForReplIndex = new boolean[searchLength];
        int textIndex = -1;
        int replaceIndex = -1;
        for (int i = 0; i < searchLength; ++i) {
            if (noMoreMatchesForReplIndex[i]) continue;
            tempIndex = text.indexOf(replacements.get(i).getKey());
            if (tempIndex == -1) {
                noMoreMatchesForReplIndex[i] = true;
                continue;
            }
            if (textIndex != -1 && tempIndex >= textIndex) continue;
            textIndex = tempIndex;
            replaceIndex = i;
        }
        if (textIndex == -1) {
            return text;
        }
        int start = 0;
        StringBuilder buf = new StringBuilder();
        while (textIndex != -1) {
            int i;
            for (i = start; i < textIndex; ++i) {
                buf.append(text.charAt(i));
            }
            buf.append(replacements.get(replaceIndex).get(source));
            start = textIndex + replacements.get(replaceIndex).getKey().length();
            textIndex = -1;
            replaceIndex = -1;
            for (i = 0; i < searchLength; ++i) {
                if (noMoreMatchesForReplIndex[i]) continue;
                tempIndex = text.indexOf(replacements.get(i).getKey(), start);
                if (tempIndex == -1) {
                    noMoreMatchesForReplIndex[i] = true;
                    continue;
                }
                if (textIndex != -1 && tempIndex >= textIndex) continue;
                textIndex = tempIndex;
                replaceIndex = i;
            }
        }
        int textLength = text.length();
        for (int i = start; i < textLength; ++i) {
            buf.append(text.charAt(i));
        }
        return buf.toString();
    }

    @NotNull
    public static <T> String replacePlaceholders(@NotNull String string, @NotNull List<PlaceholderEntry<T>> replacements, @NotNull T source) {
        LinkedHashMap<String, Supplier<String>> placeholders = new LinkedHashMap<String, Supplier<String>>();
        replacements.forEach(entry -> placeholders.put(entry.getKey(), () -> entry.get(source)));
        return StringUtil.replacePlaceholders(string, placeholders);
    }

    @NotNull
    public static String replacePlaceholders(@NotNull String string, @NotNull LinkedHashMap<String, Supplier<String>> placeholders) {
        if (string.isBlank()) {
            return string;
        }
        StringBuilder builder = new StringBuilder();
        int length = string.length();
        for (int index = 0; index < length; ++index) {
            char letter = string.charAt(index);
            if (letter == '%') {
                String key;
                Supplier<String> supplier;
                if (index + 1 < length && string.charAt(index + 1) == '%') {
                    builder.append('%');
                    ++index;
                    continue;
                }
                int indexNext = string.indexOf(letter, index + 1);
                if (indexNext != -1 && (supplier = placeholders.get(key = string.substring(index + 1, indexNext))) != null) {
                    builder.append(supplier.get());
                    index = indexNext;
                    continue;
                }
            }
            builder.append(letter);
        }
        return builder.toString();
    }

    @Nullable
    public static String parseQuotedContent(@NotNull String string) {
        char quote = string.charAt(0);
        if (quote != '\'' && quote != '\"') {
            return null;
        }
        if (string.length() < 3) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int index = 1; index < string.length(); ++index) {
            char letter = string.charAt(index);
            if (letter == '\\') continue;
            if (letter == quote) break;
            builder.append(letter);
        }
        return builder.toString();
    }

    @Deprecated
    @NotNull
    public static <T extends Enum<T>> Optional<T> getEnum(String str, @NotNull Class<T> clazz) {
        return Enums.parse((String)str, clazz);
    }

    @Deprecated
    @NotNull
    public static String inlineEnum(@NotNull Class<? extends Enum<?>> clazz, @NotNull String delimiter) {
        return Enums.inline(clazz, (String)delimiter);
    }

    @NotNull
    public static Color getColor(@NotNull String str) {
        int blue;
        int green;
        String[] rgb = str.split(",");
        int red = NumberUtil.getIntegerAbs(rgb[0]);
        if (red < 0) {
            red = Rnd.get(255);
        }
        int n = green = rgb.length >= 2 ? NumberUtil.getIntegerAbs(rgb[1]) : 0;
        if (green < 0) {
            green = Rnd.get(255);
        }
        int n2 = blue = rgb.length >= 3 ? NumberUtil.getIntegerAbs(rgb[2]) : 0;
        if (blue < 0) {
            blue = Rnd.get(255);
        }
        return Color.fromRGB((int)red, (int)green, (int)blue);
    }

    @Deprecated
    @NotNull
    public static String transformForID(@NotNull String str) {
        return StringUtil.transformForID(str, -1);
    }

    @Deprecated
    @NotNull
    public static String transformForID(@NotNull String str, int length) {
        return Strings.filterForVariable((String)str, (int)length);
    }

    @NotNull
    public static String lowerCaseUnderscore(@NotNull String str) {
        return LowerCase.INTERNAL.apply(str).replace(' ', '_');
    }

    @Deprecated
    @NotNull
    public static String lowerCaseUnderscore(@NotNull String str, int length) {
        return StringUtil.lowerCaseAndClean(str, ID_PATTERN, length);
    }

    @Deprecated
    @NotNull
    public static String lowerCaseUnderscoreStrict(@NotNull String str) {
        return StringUtil.lowerCaseUnderscoreStrict(str, -1);
    }

    @Deprecated
    @NotNull
    public static String lowerCaseUnderscoreStrict(@NotNull String str, int length) {
        return StringUtil.lowerCaseAndClean(str, ID_STRICT_PATTERN, length);
    }

    @Deprecated
    @NotNull
    private static String lowerCaseAndClean(@NotNull String str, @NotNull Pattern pattern, int length) {
        String clean = LowerCase.INTERNAL.apply(NightMessage.stripTags((String)str)).replace(" ", "_");
        if (length > 0 && clean.length() > length) {
            clean = clean.substring(0, length);
        }
        TimedMatcher matcher = TimedMatcher.create(pattern, clean, 200L);
        return matcher.replaceAll("");
    }

    @NotNull
    public static String capitalizeUnderscored(@NotNull String str) {
        return StringUtil.capitalizeFully(str.replace("_", " "));
    }

    @NotNull
    public static String capitalizeFully(@NotNull String str) {
        return StringUtil.capitalize(LowerCase.USER_LOCALE.apply(str));
    }

    @NotNull
    public static String capitalize(@NotNull String str) {
        if (str.isEmpty()) {
            return str;
        }
        int length = str.length();
        StringBuilder builder = new StringBuilder(length);
        boolean capitalizeNext = true;
        for (int index = 0; index < length; ++index) {
            char letter = str.charAt(index);
            if (Character.isWhitespace(letter)) {
                builder.append(letter);
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                builder.append(Character.toTitleCase(letter));
                capitalizeNext = false;
                continue;
            }
            builder.append(letter);
        }
        return builder.toString();
    }

    @NotNull
    public static String capitalizeFirstLetter(@NotNull String original) {
        if (original.isEmpty()) {
            return original;
        }
        return original.substring(0, 1).toUpperCase() + original.substring(1);
    }
}

