/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.language.entry.LangItem;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.Plugins;
import su.nightexpress.nightcore.util.placeholder.PlaceholderList;
import su.nightexpress.nightcore.util.placeholder.PlaceholderMap;
import su.nightexpress.nightcore.util.placeholder.Replacer;
import su.nightexpress.nightcore.util.text.night.NightMessage;

@Deprecated
public class ItemReplacer {
    private final ItemStack item;
    private final ItemMeta meta;
    private final Replacer replacer;
    private String displayName;
    private List<String> lore;
    @Deprecated
    private boolean trimLore;
    private boolean hideFlags;

    public ItemReplacer(@NotNull ItemStack item) {
        this(item, item.getItemMeta());
    }

    public ItemReplacer(@NotNull ItemMeta meta) {
        this(null, meta);
    }

    public ItemReplacer(@Nullable ItemStack item, @Nullable ItemMeta meta) {
        this.item = item;
        this.meta = meta;
        this.replacer = new Replacer();
    }

    @NotNull
    public static ItemReplacer create(@NotNull ItemStack item) {
        return new ItemReplacer(item);
    }

    @NotNull
    public static ItemReplacer create(@NotNull ItemMeta meta) {
        return new ItemReplacer(meta);
    }

    @NotNull
    public ItemReplacer readMeta() {
        if (this.hasMeta()) {
            this.setDisplayName(this.meta.getDisplayName());
            this.setLore(this.meta.getLore());
        }
        return this;
    }

    @NotNull
    public ItemReplacer readLocale(@NotNull LangItem locale) {
        if (this.hasMeta()) {
            this.setDisplayName(locale.getLocalizedName());
            this.setLore(locale.getLocalizedLore());
        }
        return this;
    }

    public void writeMeta() {
        if (!this.hasMeta()) {
            return;
        }
        if (this.displayName != null) {
            this.meta.setDisplayName(NightMessage.asLegacy((String)this.replacer.apply(this.displayName)));
        }
        if (this.lore != null) {
            this.replacer.getReplacers().forEach(this::replaceLore);
            this.meta.setLore(this.packTrimmedLore());
        }
        if (this.hasItem()) {
            this.item.setItemMeta(this.meta);
        }
        if (this.isHideFlags()) {
            ItemUtil.hideAttributes(this.item);
        }
        this.replacer.clear();
    }

    @Deprecated
    public static void replace(@NotNull ItemMeta meta, @NotNull UnaryOperator<String> replacer) {
        ItemReplacer.create(meta).trimmed().readMeta().replace(replacer).writeMeta();
    }

    @Deprecated
    public static void replace(@NotNull ItemStack item, @NotNull PlaceholderMap replacer) {
        ItemReplacer.create(item).trimmed().readMeta().replace(replacer).writeMeta();
    }

    @Deprecated
    public static void replace(@NotNull ItemMeta meta, @NotNull PlaceholderMap replacer) {
        ItemReplacer.create(meta).trimmed().readMeta().replace(replacer).writeMeta();
    }

    @Deprecated
    public static void replacePlaceholderAPI(@NotNull ItemMeta meta, @NotNull Player player) {
        ItemReplacer.create(meta).trimmed().readMeta().replacePlaceholderAPI(player).writeMeta();
    }

    public static void replace(@NotNull ItemStack itemStack, @NotNull UnaryOperator<String> operator) {
        ItemReplacer.create(itemStack).readMeta().replacement(replacer -> replacer.replace(operator)).writeMeta();
    }

    public static <T> void replace(@NotNull ItemStack itemStack, @NotNull PlaceholderList<T> placeholderList, @NotNull T source) {
        ItemReplacer.create(itemStack).readMeta().replacement(replacer -> replacer.replace(source, placeholderList)).writeMeta();
    }

    public static void replacePlaceholderAPI(@NotNull ItemStack item, @NotNull Player player) {
        ItemReplacer.create(item).readMeta().replacement(replacer -> replacer.replacePlaceholderAPI(player)).writeMeta();
    }

    public boolean hasMeta() {
        return this.meta != null;
    }

    public boolean hasItem() {
        return this.item != null;
    }

    @Deprecated
    public boolean isTrimLore() {
        return this.trimLore;
    }

    public boolean isHideFlags() {
        return this.hideFlags;
    }

    @Deprecated
    @NotNull
    public ItemReplacer trimmed() {
        this.setTrimLore(true);
        return this;
    }

    @NotNull
    public ItemReplacer hideFlags() {
        this.hideFlags = true;
        return this;
    }

    @Deprecated
    @NotNull
    public ItemReplacer setHideFlags(boolean hideFlags) {
        this.hideFlags = hideFlags;
        return this;
    }

    @Deprecated
    @NotNull
    public ItemReplacer setTrimLore(boolean trimLore) {
        this.trimLore = trimLore;
        return this;
    }

    @Deprecated
    @NotNull
    private ItemReplacer cachePlaceholder(@NotNull String placeholder, @NotNull Supplier<String> value) {
        this.replacer.replace(placeholder, value);
        return this;
    }

    @Deprecated
    @NotNull
    private ItemReplacer cachePlaceholder(@NotNull String placeholder, @NotNull String value) {
        this.replacer.replace(placeholder, value);
        return this;
    }

    @Deprecated
    @NotNull
    private ItemReplacer cacheOperator(@NotNull UnaryOperator<String> operator) {
        this.replacer.replace(operator);
        return this;
    }

    @Deprecated
    @NotNull
    public ItemReplacer replace(@NotNull String placeholder, @NotNull String value) {
        return this.cachePlaceholder(placeholder, value);
    }

    @Deprecated
    @NotNull
    public ItemReplacer replace(@NotNull String placeholder, @NotNull Supplier<String> value) {
        return this.cachePlaceholder(placeholder, value);
    }

    @Deprecated
    @NotNull
    public ItemReplacer replace(@NotNull String placeholder, @NotNull List<String> replacer) {
        return this.cacheOperator(str -> str.replace(placeholder, String.join((CharSequence)"\n", replacer)));
    }

    @Deprecated
    @NotNull
    public <T> ItemReplacer replace(@NotNull String placeholder, @NotNull PlaceholderList<T> placeholderList, @NotNull T source) {
        return this.cacheOperator(placeholderList.replacer(source));
    }

    public ItemReplacer replacement(@NotNull Consumer<Replacer> consumer) {
        consumer.accept(this.replacer);
        return this;
    }

    @Deprecated
    @NotNull
    public ItemReplacer replace(PlaceholderMap ... placeholderMaps) {
        for (PlaceholderMap placeholder : placeholderMaps) {
            this.replacer.replace(placeholder.replacer());
        }
        return this;
    }

    @Deprecated
    @NotNull
    public ItemReplacer replace(@NotNull UnaryOperator<String> replacer) {
        return this.cacheOperator(replacer);
    }

    @Deprecated
    @NotNull
    public ItemReplacer replacePlaceholderAPI(@NotNull Player player) {
        if (Plugins.hasPlaceholderAPI()) {
            this.cacheOperator(str -> PlaceholderAPI.setPlaceholders((Player)player, (String)str));
        }
        return this;
    }

    @Deprecated
    @NotNull
    public ItemReplacer replaceLoreExact(@NotNull String placeholder, @NotNull List<String> replacer) {
        return this.replace(placeholder, replacer);
    }

    @Deprecated
    @NotNull
    public ItemReplacer replaceLore(@NotNull String placeholder, @NotNull Supplier<List<String>> replacer) {
        return this.replace(placeholder, replacer.get());
    }

    @Deprecated
    @NotNull
    public ItemReplacer injectLore(@NotNull String placeholder, @NotNull List<String> replacer) {
        return this.replace(placeholder, replacer);
    }

    @Deprecated
    @NotNull
    public ItemReplacer injectPlaceholderAPI(@NotNull Player player) {
        return this.replacePlaceholderAPI(player);
    }

    @Deprecated
    @NotNull
    public ItemReplacer replaceLoreTrail(@NotNull String placeholder, @NotNull List<String> replacer) {
        if (this.getLore() == null) {
            return this;
        }
        ArrayList<String> loreReplaced = new ArrayList<String>();
        for (String lineHas : this.packLore()) {
            if (lineHas.contains(placeholder)) {
                replacer.forEach(lineRep -> loreReplaced.add(lineHas.replace(placeholder, (CharSequence)lineRep)));
                continue;
            }
            loreReplaced.add(lineHas);
        }
        this.setLore(loreReplaced);
        return this;
    }

    @NotNull
    public List<String> packLore() {
        return this.lore == null ? new ArrayList() : this.lore;
    }

    private void replaceLore(@NotNull UnaryOperator<String> operator) {
        ArrayList<String> replaced = new ArrayList<String>();
        for (String line : this.lore) {
            if (!line.isBlank()) {
                if ((line = (String)operator.apply(line)).isBlank()) continue;
                replaced.addAll(Arrays.asList(line.split("\n")));
                continue;
            }
            replaced.add(line);
        }
        this.setLore(replaced);
    }

    @NotNull
    public List<String> packTrimmedLore() {
        List lore = this.packLore();
        if (this.isTrimLore()) {
            lore = Lists.stripEmpty(lore);
        }
        List<String> fixed = this.addEmptyLines(lore);
        return Lists.modify(fixed, NightMessage::asLegacy);
    }

    @NotNull
    private List<String> addEmptyLines(@NotNull List<String> lore) {
        for (int index = 0; index < lore.size(); ++index) {
            String line = lore.get(index);
            if (line.equalsIgnoreCase("%empty-if-above%")) {
                if (index == 0 || this.isEmpty(lore.get(index - 1))) {
                    lore.remove(index);
                } else {
                    lore.set(index, "");
                }
                return this.addEmptyLines(lore);
            }
            if (!line.equalsIgnoreCase("%empty-if-below%")) continue;
            if (index == lore.size() - 1 || this.isEmpty(lore.get(index + 1))) {
                lore.remove(index);
            } else {
                lore.set(index, "");
            }
            return this.addEmptyLines(lore);
        }
        return lore;
    }

    private boolean isEmpty(@NotNull String line) {
        return line.isBlank() || line.equalsIgnoreCase("%empty-if-above%") || line.equalsIgnoreCase("%empty-if-below%");
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public ItemReplacer setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    public List<String> getLore() {
        return this.lore;
    }

    @NotNull
    public ItemReplacer setLore(@Nullable List<String> lore) {
        this.lore = lore;
        return this;
    }

    @NotNull
    public ItemReplacer setLore(@Nullable String lore) {
        this.lore = lore == null ? null : Lists.newList((Object[])lore.split("\n"));
        return this;
    }
}

