/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.ui.menu.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Keyed;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.click.ClickKey;
import su.nightexpress.nightcore.ui.menu.data.Filled;
import su.nightexpress.nightcore.ui.menu.item.ItemClick;
import su.nightexpress.nightcore.ui.menu.item.ItemHandler;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.util.BukkitThing;
import su.nightexpress.nightcore.util.Enums;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.Strings;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.NightMessage;

public class MenuLoader {
    private static final String ITEM_SECTION = "Content";
    private final Menu menu;
    private final FileConfig config;
    private final Map<String, MenuItem> defaultItems;
    private final Map<String, ItemHandler> handlerMap;

    public MenuLoader(@NotNull Menu menu, @NotNull FileConfig config) {
        this.menu = menu;
        this.config = config;
        this.defaultItems = new LinkedHashMap<String, MenuItem>();
        this.handlerMap = new LinkedHashMap<String, ItemHandler>();
        this.addHandler(ItemHandler.forClose(menu));
        this.addHandler(ItemHandler.forUserSkin(menu));
        if (menu instanceof Filled) {
            this.addHandler(ItemHandler.forNextPage(menu));
            this.addHandler(ItemHandler.forPreviousPage(menu));
        }
    }

    public void addDefaultItem(@NotNull MenuItem.Builder builder) {
        this.addDefaultItem(builder.build());
    }

    public void addDefaultItem(@NotNull MenuItem menuItem) {
        Object name;
        NightItem item = menuItem.getItem();
        ItemHandler handler = menuItem.getHandler();
        if (handler != null) {
            name = handler.getName();
            this.addHandler(handler);
        } else {
            String displayName = item.getDisplayName();
            String stripped = displayName == null ? null : Strings.filterForVariable((String)NightMessage.stripTags((String)displayName));
            name = stripped != null && !stripped.isBlank() ? stripped : BukkitThing.getValue((Keyed)item.getMaterial());
        }
        name = LowerCase.INTERNAL.apply((String)name);
        if (this.defaultItems.containsKey(name)) {
            name = (String)name + "_" + UUID.randomUUID().toString().substring(0, 8);
        }
        this.defaultItems.put((String)name, menuItem);
    }

    @NotNull
    public ItemHandler addHandler(@NotNull String name, @NotNull ItemClick click) {
        return this.addHandler(new ItemHandler(name, click));
    }

    @NotNull
    public ItemHandler addHandler(@NotNull ItemHandler handler) {
        this.handlerMap.put(handler.getName(), handler);
        return handler;
    }

    public void loadSettings() {
        MenuType menuType;
        if (this.config.contains("Settings.Inventory_Type")) {
            InventoryType oldType = this.config.getEnum("Settings.Inventory_Type", InventoryType.class, InventoryType.CHEST);
            int oldSize = this.config.getInt("Settings.Size", 27);
            MenuType newType = MenuLoader.getNewType(oldType, oldSize);
            this.config.set("Settings.MenuType", BukkitThing.getAsString((Keyed)newType));
            this.config.remove("Settings.Inventory_Type");
            this.config.remove("Settings.Size");
        }
        this.menu.setMenuType((MenuType)((menuType = BukkitThing.getMenuType((String)ConfigValue.create("Settings.MenuType", BukkitThing.getAsString((Keyed)this.menu.getMenuType()), new String[0]).read(this.config))) == null ? MenuType.GENERIC_9X3 : menuType));
        this.menu.setTitle(ConfigValue.create("Settings.Title", this.menu.getTitle(), new String[0]).read(this.config));
        this.menu.setAutoRefreshInterval(ConfigValue.create("Settings.Auto_Refresh", this.menu.getAutoRefreshInterval(), new String[0]).read(this.config));
        this.menu.setApplyPlaceholderAPI(ConfigValue.create("Settings.PlaceholderAPI.Enabled", this.menu.isApplyPlaceholderAPI(), new String[0]).read(this.config));
    }

    private static MenuType getNewType(InventoryType oldType, int oldSize) {
        MenuType.Typed newType;
        if (oldType == InventoryType.CHEST) {
            newType = oldSize == 54 ? MenuType.GENERIC_9X6 : (oldSize == 45 ? MenuType.GENERIC_9X5 : (oldSize == 36 ? MenuType.GENERIC_9X4 : (oldSize == 27 ? MenuType.GENERIC_9X3 : (oldSize == 18 ? MenuType.GENERIC_9X2 : MenuType.GENERIC_9X1))));
        } else {
            newType = switch (oldType) {
                case InventoryType.CARTOGRAPHY -> MenuType.CARTOGRAPHY_TABLE;
                case InventoryType.ANVIL -> MenuType.ANVIL;
                case InventoryType.LOOM -> MenuType.LOOM;
                case InventoryType.SMITHING -> MenuType.SMITHING;
                case InventoryType.GRINDSTONE -> MenuType.GRINDSTONE;
                case InventoryType.STONECUTTER -> MenuType.STONECUTTER;
                case InventoryType.SMOKER -> MenuType.SMOKER;
                case InventoryType.BEACON -> MenuType.BEACON;
                case InventoryType.HOPPER -> MenuType.HOPPER;
                case InventoryType.BREWING -> MenuType.BREWING_STAND;
                case InventoryType.DROPPER, InventoryType.DISPENSER -> MenuType.GENERIC_3X3;
                case InventoryType.FURNACE -> MenuType.FURNACE;
                case InventoryType.LECTERN -> MenuType.LECTERN;
                case InventoryType.ENCHANTING -> MenuType.ENCHANTMENT;
                case InventoryType.BLAST_FURNACE -> MenuType.BLAST_FURNACE;
                default -> MenuType.GENERIC_9X3;
            };
        }
        return newType;
    }

    public void loadItems() {
        if (!this.config.contains(ITEM_SECTION)) {
            this.defaultItems.forEach((id, menuItem) -> this.writeItem((MenuItem)menuItem, "Content." + id));
        }
        this.config.getSection(ITEM_SECTION).forEach(sId -> {
            MenuItem menuItem = this.readItem("Content." + sId);
            this.menu.addItem(menuItem);
        });
    }

    public void loadComments() {
        List list = Lists.newList((Object[])new String[]{"=".repeat(20) + " [SECTION] SETTINGS " + "=".repeat(20), "> [MenuType] : String | Represents the menu type. Allowed values: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/inventory/MenuType.html", "> [Title] : String | Sets menu title.", "> [Auto_Refresh] : Integer | Defines menu refresh rate in seconds. Set 0 to disable.", "> [PlaceholderAPI -> Enabled] : Boolean | When enabled, applies PlaceholderAPI placeholders for all items in the menu per player.", " ", "=".repeat(20) + " [SECTION] CONTENT " + "=".repeat(20), "You can freely edit items in this section as you wish (add, remove, modify items).", "> [Item] : Section | Item to display.", "    [*] Navigate to https://nightexpressdev.com/nightcore/configuration/item-formation/ for a list of available options.", "> [Priority] : Integer | Item priority. Higher values will override other item(s) in the same slot(s).", "> [Slots] : Int Array | Item slots, starts from 0. Split with commas.", "    Slots: '0,4,9,10'", "> [Type] : String | Defines item click action.", "    [*] Available types: [" + String.join((CharSequence)", ", this.handlerMap.keySet().stream().map(str -> "'" + str + "'").toList()) + "]", "> [Click_Commands] : Section | Executes commands on click with PlaceholderAPI support.", "    [*] Works only if [Type] is not set (null).", "    [*] Available click types: [" + Enums.inline(ClickKey.class) + "]", "    [*] Use prefix 'player:' to run command by a player.", "    Click_Commands:", "      " + ClickKey.LEFT.name() + ":", "      - say Hello", "      - give %player_name% diamond 1", "      - player: warp shop", "=".repeat(50)});
        this.config.setComments("Settings", list);
    }

    @NotNull
    protected MenuItem readItem(@NotNull String path) {
        ItemHandler commandHandler;
        NightItem item = this.config.getCosmeticItem(path + ".Item");
        int priority = this.config.getInt(path + ".Priority");
        int[] slots = this.config.getIntArray(path + ".Slots");
        String handlerName = this.config.getString(path + ".Type", "default");
        ItemHandler typedHandler = this.handlerMap.get(handlerName.toLowerCase());
        if (this.config.contains(path + ".Click_Commands")) {
            HashMap<ClickKey, List> commandMap = new HashMap<ClickKey, List>();
            for (String sType : this.config.getSection(path + ".Click_Commands")) {
                List commands;
                ClickKey clickType = (ClickKey)Enums.get((String)sType, ClickKey.class);
                if (clickType == null || (commands = this.config.getStringList(path + ".Click_Commands." + sType)).isEmpty()) continue;
                commandMap.put(clickType, commands);
            }
            commandHandler = ItemHandler.forClick((viewer, event) -> {
                List<String> commands = commandMap.getOrDefault((Object)ClickKey.from(event), Collections.emptyList());
                commands.forEach(command -> Players.dispatchCommand(viewer.getPlayer(), command));
            });
        } else {
            commandHandler = null;
        }
        ItemHandler handler = typedHandler == null ? commandHandler : typedHandler;
        return new MenuItem(item, priority, slots, handler);
    }

    protected void writeItem(@NotNull MenuItem menuItem, @NotNull String path) {
        this.config.set(path + ".Priority", menuItem.getPriority());
        this.config.set(path + ".Item", menuItem.getItem());
        this.config.setIntArray(path + ".Slots", menuItem.getSlots());
        this.config.set(path + ".Type", menuItem.getHandler() == null ? "null" : menuItem.getHandler().getName());
    }
}

