/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.locale.entry;

import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.LangValue;
import su.nightexpress.nightcore.util.text.night.ParserUtils;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class DialogElementLocale
extends LangEntry<Value> {
    public DialogElementLocale(@NotNull String path, @NotNull Value defaultValue) {
        super(Value::read, path, defaultValue);
    }

    @NotNull
    public static DialogElementLocale create(@NotNull String path, String ... contents) {
        return DialogElementLocale.create(path, 200, contents);
    }

    @NotNull
    public static DialogElementLocale create(@NotNull String path, int width, String ... contents) {
        return new DialogElementLocale(path, new Value(String.join((CharSequence)TagWrappers.BR, contents), width));
    }

    @NotNull
    public DialogElementLocale replace(@NotNull UnaryOperator<String> operator) {
        return DialogElementLocale.create(this.path, this.width(), (String)operator.apply(this.contents()));
    }

    @NotNull
    public String contents() {
        return ((Value)this.value).contents();
    }

    public int width() {
        return ((Value)this.value).width();
    }

    public record Value(@NotNull String contents, int width) implements LangValue
    {
        @NotNull
        public static Value read(@NotNull FileConfig config, @NotNull String path) {
            List list = config.getStringList(path + ".Contents");
            String contents = !list.isEmpty() ? String.join((CharSequence)TagWrappers.BR, list) : String.valueOf(config.getString(path + ".Contents"));
            int width = config.getInt(path + ".Width");
            return new Value(contents, width);
        }

        @Override
        public void write(@NotNull FileConfig config, @NotNull String path) {
            List<String> list = Arrays.asList(ParserUtils.breakDownLineSplitters((String)this.contents));
            config.set(path + ".Contents", list.size() != 1 ? list : list.getFirst());
            config.set(path + ".Width", this.width);
        }
    }
}

