/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.language;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.NightCore;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.language.LangManager;
import su.nightexpress.nightcore.util.BukkitThing;
import su.nightexpress.nightcore.util.FileUtil;
import su.nightexpress.nightcore.util.StringUtil;
import su.nightexpress.nightcore.util.Version;
import su.nightexpress.nightcore.util.bridge.RegistryType;

@Deprecated
public class LangAssets {
    private static FileConfig config;

    public static void load(@NotNull NightCore core) {
        String langCode = core.getLanguage();
        String assetsCode = LangAssets.downloadAssets(core, langCode);
        config = FileConfig.loadOrExtract(core, "/lang/", LangAssets.getFileName(assetsCode));
        if (Version.isAtLeast((Version)Version.MC_1_21)) {
            LangAssets.loadDamageTypes();
        }
    }

    public static void shutdown() {
        config.saveChanges();
        config = null;
    }

    private static void loadDamageTypes() {
        BukkitThing.getAll((RegistryType)RegistryType.DAMAGE_TYPE).forEach(damageType -> LangAssets.getOrCreate("DamageType", (Keyed)damageType));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static String downloadAssets(@NotNull NightCore plugin, @NotNull String langCode) {
        File file = new File(plugin.getDataFolder().getAbsolutePath() + "/lang/", LangAssets.getFileName(langCode));
        if (file.exists()) {
            return langCode;
        }
        FileUtil.create(file);
        String url = "https://github.com/nulli0n/nightcore-spigot/raw/master/assets/" + langCode + ".yml";
        try (BufferedInputStream in = new BufferedInputStream(new URL(url).openStream());){
            String string;
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                int bytesRead;
                plugin.info("Downloading '" + langCode + "' assets from github...");
                byte[] dataBuffer = new byte[1024];
                while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                    fileOutputStream.write(dataBuffer, 0, bytesRead);
                }
                string = langCode;
            }
            return string;
        }
        catch (IOException exception) {
            plugin.error("Could not download language assets for '" + langCode + "' (no such assets?).");
            return LangManager.isDefault(langCode) ? langCode : LangAssets.downloadAssets(plugin, "en");
        }
    }

    @NotNull
    private static String getFileName(@NotNull String langCode) {
        return "assets_" + langCode + ".yml";
    }

    @NotNull
    public static FileConfig getConfig() {
        return config;
    }

    @Deprecated
    @NotNull
    public static String get(@NotNull PotionEffectType type) {
        return LangAssets.getAsset("PotionEffectType", (Keyed)type);
    }

    @Deprecated
    @NotNull
    public static String get(@NotNull EntityType type) {
        return LangAssets.getAsset("EntityType", (Keyed)type);
    }

    @Deprecated
    @NotNull
    public static String get(@NotNull Material type) {
        return LangAssets.getAsset("Material", (Keyed)type);
    }

    @NotNull
    public static String get(@NotNull World world) {
        return LangAssets.getOrCreate("World", (Keyed)world);
    }

    @Deprecated
    @NotNull
    public static String get(@NotNull Enchantment enchantment) {
        return LangAssets.getOrCreate("Enchantment", (Keyed)enchantment);
    }

    @NotNull
    public static String get(@NotNull DamageType damageType) {
        return LangAssets.getOrCreate("DamageType", (Keyed)damageType);
    }

    @NotNull
    public static String getAsset(@NotNull String path, @NotNull Keyed keyed) {
        return LangAssets.getAsset(path, BukkitThing.toString((Keyed)keyed));
    }

    @NotNull
    public static String getAsset(@NotNull String path, @NotNull String nameRaw) {
        return LangAssets.getAsset(path + "." + nameRaw).orElse(nameRaw);
    }

    @NotNull
    public static Optional<String> getAsset(@NotNull String path) {
        return Optional.ofNullable(config.getString(path));
    }

    @NotNull
    public static String getOrCreate(@NotNull String path, @NotNull Keyed keyed) {
        return LangAssets.getOrCreate(path, BukkitThing.toString((Keyed)keyed));
    }

    @NotNull
    public static String getOrCreate(@NotNull String path, @NotNull String nameRaw) {
        config.addMissing(path + "." + nameRaw, StringUtil.capitalizeUnderscored(nameRaw));
        return LangAssets.getAsset(path, nameRaw);
    }
}

