/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.integration.currency.impl;

import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.integration.currency.CurrencySettings;
import su.nightexpress.nightcore.integration.currency.type.IncompleteCurrency;
import su.nightexpress.nightcore.util.bukkit.NightItem;

public class XPLevelsCurrency
extends IncompleteCurrency {
    public XPLevelsCurrency() {
        super("xp_level");
    }

    public boolean canHandleDecimals() {
        return false;
    }

    public boolean canHandleOffline() {
        return false;
    }

    @Override
    @NotNull
    public CurrencySettings getDefaultSettings() {
        return CurrencySettings.createDefault("XP Levels", NightItem.fromType(Material.EXPERIENCE_BOTTLE));
    }

    public double getBalance(@NotNull Player player) {
        return player.getLevel();
    }

    public double getBalance(@NotNull UUID playerId) {
        return 0.0;
    }

    public void give(@NotNull Player player, double amount) {
        player.setLevel(player.getLevel() + (int)amount);
    }

    public void give(@NotNull UUID playerId, double amount) {
    }

    public void take(@NotNull Player player, double amount) {
        player.setLevel(Math.max(0, player.getLevel() - (int)amount));
    }

    public void take(@NotNull UUID playerId, double amount) {
    }
}

