/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.integration.currency.impl;

import java.util.UUID;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.PlayerPointsAPI;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.integration.currency.CurrencySettings;
import su.nightexpress.nightcore.integration.currency.type.IncompleteCurrency;
import su.nightexpress.nightcore.util.bukkit.NightItem;

public class PlayerPointsCurrency
extends IncompleteCurrency {
    private final PlayerPointsAPI api = PlayerPoints.getInstance().getAPI();

    public PlayerPointsCurrency() {
        super("playerpoints");
    }

    public boolean canHandleDecimals() {
        return false;
    }

    public boolean canHandleOffline() {
        return true;
    }

    @Override
    @NotNull
    public CurrencySettings getDefaultSettings() {
        return CurrencySettings.createDefault("Points", NightItem.fromType(Material.SUNFLOWER));
    }

    public double getBalance(@NotNull Player player) {
        return this.getBalance(player.getUniqueId());
    }

    public double getBalance(@NotNull UUID playerId) {
        return this.api.look(playerId);
    }

    public void give(@NotNull Player player, double amount) {
        this.give(player.getUniqueId(), amount);
    }

    public void give(@NotNull UUID playerId, double amount) {
        this.api.give(playerId, (int)amount);
    }

    public void take(@NotNull Player player, double amount) {
        this.take(player.getUniqueId(), amount);
    }

    public void take(@NotNull UUID playerId, double amount) {
        this.api.take(playerId, (int)amount);
    }
}

