/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.integration.currency.impl;

import com.magmaguy.elitemobs.economy.EconomyHandler;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.integration.currency.CurrencySettings;
import su.nightexpress.nightcore.integration.currency.type.IncompleteCurrency;
import su.nightexpress.nightcore.util.bukkit.NightItem;

public class EliteMobsCurrency
extends IncompleteCurrency {
    public EliteMobsCurrency() {
        super("elitemobs");
    }

    public boolean canHandleDecimals() {
        return true;
    }

    public boolean canHandleOffline() {
        return true;
    }

    @Override
    @NotNull
    public CurrencySettings getDefaultSettings() {
        return CurrencySettings.createDefault("Elite Tokens", NightItem.fromType(Material.EMERALD));
    }

    public double getBalance(@NotNull Player player) {
        return this.getBalance(player.getUniqueId());
    }

    public double getBalance(@NotNull UUID playerId) {
        return EconomyHandler.checkCurrency((UUID)playerId, (boolean)true);
    }

    public void give(@NotNull Player player, double amount) {
        this.give(player.getUniqueId(), amount);
    }

    public void give(@NotNull UUID playerId, double amount) {
        EconomyHandler.addCurrency((UUID)playerId, (double)amount);
    }

    public void take(@NotNull Player player, double amount) {
        this.take(player.getUniqueId(), amount);
    }

    public void take(@NotNull UUID playerId, double amount) {
        EconomyHandler.subtractCurrency((UUID)playerId, (double)amount);
    }
}

