/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.integration.currency;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.NightCore;
import su.nightexpress.nightcore.bridge.currency.Currency;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.CoreConfig;
import su.nightexpress.nightcore.integration.currency.CurrencySettings;
import su.nightexpress.nightcore.integration.currency.EconomyBridge;
import su.nightexpress.nightcore.integration.currency.command.CurrencyCommands;
import su.nightexpress.nightcore.integration.currency.impl.BeastTokensCurrency;
import su.nightexpress.nightcore.integration.currency.impl.CoinsEngineCurrency;
import su.nightexpress.nightcore.integration.currency.impl.EliteMobsCurrency;
import su.nightexpress.nightcore.integration.currency.impl.ItemStackCurrency;
import su.nightexpress.nightcore.integration.currency.impl.PlayerPointsCurrency;
import su.nightexpress.nightcore.integration.currency.impl.UltraEconomyCurrency;
import su.nightexpress.nightcore.integration.currency.impl.VaultEconomyCurrency;
import su.nightexpress.nightcore.integration.currency.impl.VotingPluginCurrency;
import su.nightexpress.nightcore.integration.currency.impl.XPLevelsCurrency;
import su.nightexpress.nightcore.integration.currency.listener.CurrencyListener;
import su.nightexpress.nightcore.integration.currency.type.IncompleteCurrency;
import su.nightexpress.nightcore.manager.AbstractManager;
import su.nightexpress.nightcore.util.ItemTag;
import su.nightexpress.nightcore.util.Plugins;
import su.nightexpress.nightcore.util.Strings;

public class CurrencyManager
extends AbstractManager<NightCore> {
    public static final String FILE_NAME = "currencies.yml";
    private final Map<String, Runnable> pluginProviders = new HashMap<String, Runnable>();
    private FileConfig config;

    public CurrencyManager(@NotNull NightCore plugin) {
        super(plugin);
    }

    @Override
    protected void onLoad() {
        this.config = FileConfig.loadOrExtract(this.plugin, FILE_NAME);
        this.migrateEconomyBridgeData();
        this.loadProviders();
        this.loadBuiltInCurrencies();
        this.loadItemCurrencies();
        CurrencyCommands.load((NightCore)this.plugin);
        this.addListener(new CurrencyListener((NightCore)this.plugin, this));
        ((NightCore)this.plugin).runTask(task -> {
            this.pluginProviders.clear();
            this.config.saveChanges();
        });
    }

    @Override
    protected void onShutdown() {
        this.pluginProviders.clear();
        CurrencyCommands.shutdown();
    }

    public void handlePluginLoad(@NotNull String pluginName) {
        Runnable provider = this.pluginProviders.get(pluginName);
        if (provider != null) {
            ((NightCore)this.plugin).info(pluginName + " detected! Loading currency...");
            provider.run();
        }
    }

    private void migrateEconomyBridgeData() {
        File dir = new File(((NightCore)this.plugin).getDataFolder().getParent(), "EconomyBridge");
        if (!dir.exists()) {
            return;
        }
        FileConfig itemConfig = new FileConfig(dir.getAbsolutePath(), "items.yml");
        String itemsPath = "Items";
        itemConfig.getSection(itemsPath).forEach(sId -> {
            if (this.config.contains(itemsPath + "." + sId)) {
                return;
            }
            ItemTag tag = ItemTag.read(itemConfig, itemsPath + "." + sId + ".Tag");
            this.config.set(itemsPath + "." + sId + ".Tag", tag);
        });
        FileConfig curConfig = new FileConfig(dir.getAbsolutePath(), FILE_NAME);
        String curPath = "Currencies";
        curConfig.getSection(curPath).forEach(sId -> {
            if (this.config.contains(curPath + "." + sId)) {
                return;
            }
            CurrencySettings settings = CurrencySettings.load(curConfig, curPath + "." + sId);
            String subPath = this.config.contains(itemsPath + "." + sId) ? "Items" : curPath;
            this.config.set(subPath + "." + sId + ".Settings", settings);
        });
    }

    private void loadProviders() {
        this.addExternalLoader("Vault", () -> this.loadIncompleted(VaultEconomyCurrency::new));
        this.addExternalLoader("PlayerPoints", () -> this.loadIncompleted(PlayerPointsCurrency::new));
        this.addExternalLoader("BeastTokens", () -> this.loadIncompleted(BeastTokensCurrency::new));
        this.addExternalLoader("VotingPlugin", () -> this.loadIncompleted(VotingPluginCurrency::new));
        this.addExternalLoader("EliteMobs", () -> this.loadIncompleted(EliteMobsCurrency::new));
        this.addExternalLoader("CoinsEngine", () -> CoinsEngineCurrency.getCurrencies().forEach(this::register));
        this.addExternalLoader("UltraEconomy", () -> UltraEconomyCurrency.getCurrencies().forEach(this::register));
        this.pluginProviders.keySet().forEach(pluginName -> {
            Plugin currencyPlugin = ((NightCore)this.plugin).getPluginManager().getPlugin(pluginName);
            if (currencyPlugin == null || !currencyPlugin.isEnabled()) {
                return;
            }
            this.handlePluginLoad((String)pluginName);
        });
    }

    public void loadBuiltInCurrencies() {
        this.loadIncompleted(XPLevelsCurrency::new);
    }

    public void loadItemCurrencies() {
        String path = "Items";
        if (!this.config.contains(path)) {
            ItemStackCurrency.createDefaults().forEach(currency -> this.config.set(path + "." + currency.getInternalId(), currency));
        }
        this.config.getSection(path).forEach(sId -> {
            try {
                this.loadIncompleted(() -> ItemStackCurrency.read(this.config, path + "." + sId, sId));
            }
            catch (IllegalStateException exception) {
                ((NightCore)this.plugin).error("Item currency '" + sId + "' not loaded: " + exception.getMessage());
            }
        });
    }

    @Nullable
    public ItemStackCurrency createItemCurrency(@NotNull String name, @NotNull ItemStack itemStack) {
        String id = Strings.filterForVariable((String)name);
        if (EconomyBridge.hasCurrency(id)) {
            return null;
        }
        ItemStackCurrency currency = new ItemStackCurrency(id, itemStack);
        this.saveCurrency(currency);
        this.loadIncompleted(() -> currency);
        return currency;
    }

    private void saveCurrency(@NotNull ItemStackCurrency currency) {
        this.config.set("Items." + currency.getInternalId(), currency);
        this.config.save();
    }

    private void addExternalLoader(@NotNull String pluginName, @NotNull Runnable runnable) {
        if (!Plugins.isInstalled(pluginName)) {
            return;
        }
        this.pluginProviders.put(pluginName, runnable);
    }

    public <T extends IncompleteCurrency> void loadIncompleted(@NotNull Supplier<T> supplier) {
        this.register((IncompleteCurrency)supplier.get(), currency -> {
            String path = currency instanceof ItemStackCurrency ? "Items" : "Currencies";
            CurrencySettings settings = ConfigValue.create(path + "." + currency.getInternalId() + ".Settings", CurrencySettings::load, currency.getDefaultSettings(), new String[0]).read(this.config);
            currency.setSettings(settings);
        });
    }

    private void register(@NotNull Currency currency) {
        this.register(currency, null);
    }

    private <T extends Currency> void register(@NotNull T currency, @Nullable Consumer<T> preRegister) {
        String id = currency.getInternalId();
        if (CoreConfig.ECONOMY_DISABLED_PROVIDERS.get().contains(id)) {
            return;
        }
        if (preRegister != null) {
            preRegister.accept(currency);
        }
        EconomyBridge.register(currency);
        ((NightCore)this.plugin).info("Currency registered: '" + id + "'.");
    }
}

