/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.db;

import java.sql.ResultSet;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.db.AbstractDataManager;
import su.nightexpress.nightcore.db.AbstractUser;
import su.nightexpress.nightcore.db.config.DatabaseConfig;
import su.nightexpress.nightcore.db.sql.column.Column;
import su.nightexpress.nightcore.db.sql.column.ColumnType;
import su.nightexpress.nightcore.db.sql.query.UserQueries;
import su.nightexpress.nightcore.db.sql.query.impl.InsertQuery;
import su.nightexpress.nightcore.db.sql.query.impl.SelectQuery;
import su.nightexpress.nightcore.db.sql.query.impl.UpdateQuery;
import su.nightexpress.nightcore.db.sql.query.type.ValuedQuery;
import su.nightexpress.nightcore.db.sql.util.WhereOperator;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.TimeUtil;

public abstract class AbstractUserDataManager<P extends NightPlugin, U extends AbstractUser>
extends AbstractDataManager<P> {
    public static final Column COLUMN_USER_ID = Column.of("uuid", ColumnType.STRING);
    public static final Column COLUMN_USER_NAME = Column.of("name", ColumnType.STRING);
    public static final Column COLUMN_USER_DATE_CREATED = Column.of("dateCreated", ColumnType.LONG);
    public static final Column COLUMN_USER_LAST_ONLINE = Column.of("last_online", ColumnType.LONG);
    protected final String tableUsers = this.getTablePrefix() + "_users";
    protected final Function<ResultSet, U> userFunction = this.createUserFunction();

    public AbstractUserDataManager(@NotNull P plugin) {
        this(plugin, AbstractUserDataManager.getDataConfig(plugin));
    }

    public AbstractUserDataManager(@NotNull P plugin, @NotNull DatabaseConfig config) {
        super(plugin, config);
    }

    @Override
    protected void onInitialize() {
        this.createUserTable();
    }

    @Override
    protected void onClose() {
    }

    @Override
    public void onPurge() {
        LocalDateTime deadline = LocalDateTime.now().minusDays(this.getConfig().getPurgePeriod());
        long deadlineMs = TimeUtil.toEpochMillis(deadline);
        this.delete(this.tableUsers, UserQueries.deleteByLastOnline(), deadlineMs);
    }

    @NotNull
    protected abstract Function<ResultSet, U> createUserFunction();

    protected void createUserTable() {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(COLUMN_USER_ID);
        columns.add(COLUMN_USER_NAME);
        columns.add(COLUMN_USER_DATE_CREATED);
        columns.add(COLUMN_USER_LAST_ONLINE);
        this.addTableColumns(columns);
        this.createTable(this.tableUsers, columns);
    }

    protected abstract void addUpsertQueryData(@NotNull ValuedQuery<?, U> var1);

    protected abstract void addSelectQueryData(@NotNull SelectQuery<U> var1);

    protected abstract void addTableColumns(@NotNull List<Column> var1);

    @NotNull
    public List<U> getUsers() {
        return this.select(this.tableUsers, this.userFunction, SelectQuery::all);
    }

    @Nullable
    public U getUser(@NotNull Player player) {
        return this.getUser(player.getUniqueId());
    }

    @Nullable
    public final U getUser(@NotNull String name) {
        return this.selectUser(query -> query.whereIgnoreCase(COLUMN_USER_NAME, WhereOperator.EQUAL, name.toLowerCase()));
    }

    @Nullable
    public final U getUser(@NotNull UUID uuid) {
        return this.selectUser(query -> query.where(COLUMN_USER_ID, WhereOperator.EQUAL, uuid.toString()));
    }

    private U selectUser(@NotNull Consumer<SelectQuery<U>> consumer) {
        SelectQuery<U> query = new SelectQuery<U>(this.userFunction);
        query.column(COLUMN_USER_ID);
        query.column(COLUMN_USER_NAME);
        query.column(COLUMN_USER_LAST_ONLINE);
        query.column(COLUMN_USER_DATE_CREATED);
        this.addSelectQueryData(query);
        consumer.accept(query);
        return (U)((AbstractUser)this.selectFirst(this.tableUsers, query));
    }

    public boolean isUserExists(@NotNull String name) {
        return this.contains(this.tableUsers, query -> query.column(COLUMN_USER_NAME).whereIgnoreCase(COLUMN_USER_NAME, WhereOperator.EQUAL, name.toLowerCase()));
    }

    public boolean isUserExists(@NotNull UUID uuid) {
        return this.contains(this.tableUsers, query -> query.column(COLUMN_USER_ID).where(COLUMN_USER_ID, WhereOperator.EQUAL, uuid.toString()));
    }

    public void saveUser(@NotNull U user) {
        this.saveUsers(Lists.newList((Object[])new AbstractUser[]{user}));
    }

    public void saveUsers(@NotNull Collection<U> users) {
        UpdateQuery query = UserQueries.update();
        this.addUpsertQueryData(query);
        this.update(this.tableUsers, query, users);
    }

    public void insertUser(@NotNull U user) {
        InsertQuery query = UserQueries.insert();
        this.addUpsertQueryData(query);
        this.insert(this.tableUsers, query, user);
    }

    public void deleteUser(@NotNull U user) {
        this.deleteUser(((AbstractUser)user).getId());
    }

    public void deleteUser(@NotNull UUID userId) {
        this.delete(this.tableUsers, UserQueries.deleteByUUID(), userId);
    }
}

