/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.commands.command;

import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.command.PluginIdentifiableCommand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.commands.Commands;
import su.nightexpress.nightcore.commands.builder.ExecutableNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.command.HubCommand;
import su.nightexpress.nightcore.commands.command.LiteralCommand;
import su.nightexpress.nightcore.commands.tree.CommandNode;
import su.nightexpress.nightcore.commands.tree.ExecutableNode;
import su.nightexpress.nightcore.commands.tree.HubNode;
import su.nightexpress.nightcore.commands.tree.LiteralNode;
import su.nightexpress.nightcore.util.Lists;

public interface NightCommand
extends PluginIdentifiableCommand {
    @NotNull
    public NightPlugin getPlugin();

    @NotNull
    public CommandNode getRoot();

    public boolean register();

    public boolean unregister();

    public boolean isRegistered();

    @NotNull
    public String getName();

    @Nullable
    public String getPermission();

    @NotNull
    public String getLabel();

    @NotNull
    public List<String> getAliases();

    @NotNull
    public String getDescription();

    @NotNull
    public String getUsage();

    @NotNull
    public static HubCommand forPlugin(@NotNull NightPlugin plugin, @NotNull Consumer<HubNodeBuilder> consumer) {
        String[] aliases = plugin.getDetails().getCommandAliases();
        return NightCommand.hub(plugin, aliases, (HubNodeBuilder builder) -> {
            builder.localized(plugin.getNameLocalized());
            consumer.accept((HubNodeBuilder)builder);
        });
    }

    @NotNull
    public static LiteralCommand literal(@NotNull NightPlugin plugin, @NotNull LiteralNode node) {
        return new LiteralCommand(plugin, node, Collections.emptyList());
    }

    @NotNull
    public static LiteralCommand literal(@NotNull NightPlugin plugin, @NotNull String name, @NotNull Consumer<LiteralNodeBuilder> consumer) {
        return NightCommand.literal(plugin, new String[]{name}, consumer);
    }

    @NotNull
    public static LiteralCommand literal(@NotNull NightPlugin plugin, @NotNull String[] names, @NotNull Consumer<LiteralNodeBuilder> consumer) {
        return NightCommand.create(plugin, names, Commands::literal, (root, aliases) -> new LiteralCommand(plugin, (LiteralNode)root, (List<String>)aliases), consumer);
    }

    @NotNull
    public static HubCommand hub(@NotNull NightPlugin plugin, @NotNull HubNode node) {
        return new HubCommand(plugin, node, Collections.emptyList());
    }

    @NotNull
    public static HubCommand hub(@NotNull NightPlugin plugin, @NotNull String name, @NotNull Consumer<HubNodeBuilder> consumer) {
        return NightCommand.hub(plugin, new String[]{name}, consumer);
    }

    @NotNull
    public static HubCommand hub(@NotNull NightPlugin plugin, @NotNull String[] names, @NotNull Consumer<HubNodeBuilder> consumer) {
        return NightCommand.create(plugin, names, Commands::hub, (root, aliases) -> new HubCommand(plugin, (HubNode)root, (List<String>)aliases), consumer);
    }

    @NotNull
    public static <C extends NightCommand, N extends ExecutableNode, B extends ExecutableNodeBuilder<N, B>> C create(@NotNull NightPlugin plugin, @NotNull String[] names, @NotNull Function<String, B> builderFunction, @NotNull BiFunction<N, List<String>, C> commandFunction, @NotNull Consumer<B> consumer) {
        if (names == null || names.length == 0) {
            throw new IllegalStateException("Could not create root node for empty aliases!");
        }
        List aliases = Lists.newList((Object[])names);
        ExecutableNodeBuilder builder = (ExecutableNodeBuilder)builderFunction.apply((String)aliases.removeFirst());
        consumer.accept(builder);
        return (C)((NightCommand)commandFunction.apply(builder.build(), aliases));
    }
}

