/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.command.experimental.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.command.experimental.CommandContext;
import su.nightexpress.nightcore.command.experimental.TabContext;
import su.nightexpress.nightcore.command.experimental.argument.CommandArgument;
import su.nightexpress.nightcore.command.experimental.argument.ParsedArgument;
import su.nightexpress.nightcore.command.experimental.argument.ParsedArguments;
import su.nightexpress.nightcore.command.experimental.builder.DirectNodeBuilder;
import su.nightexpress.nightcore.command.experimental.flag.CommandFlag;
import su.nightexpress.nightcore.command.experimental.flag.ContentFlag;
import su.nightexpress.nightcore.command.experimental.node.CommandNode;
import su.nightexpress.nightcore.command.experimental.node.DirectExecutor;
import su.nightexpress.nightcore.core.CoreLang;
import su.nightexpress.nightcore.util.Lists;

@Deprecated
public class DirectNode
extends CommandNode
implements DirectExecutor {
    private final List<CommandArgument<?>> arguments;
    private final Map<String, CommandFlag> flags;
    private final DirectExecutor executor;
    private final int requiredArguments;

    public DirectNode(@NotNull NightCorePlugin plugin, @NotNull String name, @NotNull String[] aliases, @NotNull String description, @Nullable String permission, boolean playerOnly, @NotNull List<CommandArgument<?>> arguments, @NotNull Map<String, CommandFlag> flags, @NotNull DirectExecutor executor) {
        super(plugin, name, aliases, description, permission, playerOnly);
        this.arguments = Collections.unmodifiableList(arguments);
        this.flags = Collections.unmodifiableMap(flags);
        this.executor = executor;
        this.requiredArguments = (int)this.arguments.stream().filter(CommandArgument::isRequired).count();
    }

    @NotNull
    public static DirectNodeBuilder builder(@NotNull NightCorePlugin plugin, String ... aliases) {
        return new DirectNodeBuilder(plugin, aliases);
    }

    @Override
    public boolean execute(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.executor.execute(context, arguments);
    }

    @Override
    protected boolean onRun(@NotNull CommandContext context) {
        CommandSender sender = context.getSender();
        String[] args = context.getArgs();
        int index = context.getArgumentIndex();
        ParsedArguments parsedArguments = new ParsedArguments();
        for (CommandArgument<?> argument : this.arguments) {
            if (index >= args.length) break;
            if (!argument.hasPermission(sender)) {
                context.errorPermission();
                return false;
            }
            String arg = argument.isComplex() ? Stream.of(args).skip(index).collect(Collectors.joining(" ")) : args[index++];
            ParsedArgument<?> parsedArgument = argument.parse(arg, context);
            if (parsedArgument == null) {
                context.send(argument.getFailureMessage(this.plugin), replacer -> replacer.replace("%value%", arg).replace("%name%", argument.getLocalized()));
                return false;
            }
            parsedArguments.add(argument, parsedArgument);
        }
        if (parsedArguments.getArgumentMap().size() < this.requiredArguments) {
            context.send(CoreLang.ERROR_COMMAND_USAGE.getMessage(this.plugin), replacer -> replacer.replace("%command_label%", this.getNameWithParents()).replace("%command_usage%", this.getUsage()).replace("%command_description%", this.getDescription()));
            return false;
        }
        if (!this.flags.isEmpty() && index < args.length) {
            for (int flagIndex = index; flagIndex < args.length; ++flagIndex) {
                int delimiterIndex;
                boolean hasDelimiter;
                String flagName;
                CommandFlag flag;
                String arg = args[flagIndex];
                if (arg.charAt(0) != '-' || (flag = this.getFlag(flagName = ((hasDelimiter = (delimiterIndex = arg.indexOf(61)) != -1) ? arg.substring(0, delimiterIndex) : arg).substring(1))) == null || parsedArguments.hasFlag(flag) || !flag.hasPermission(sender)) continue;
                if (flag instanceof ContentFlag) {
                    String content;
                    ContentFlag contentFlag = (ContentFlag)flag;
                    if (!hasDelimiter || (content = arg.substring(delimiterIndex + 1)).isEmpty()) continue;
                    ParsedArgument parsed = contentFlag.parse(content, context);
                    if (parsed == null) {
                        context.send(CoreLang.ERROR_COMMAND_PARSE_FLAG.getMessage(this.plugin), replacer -> replacer.replace("%value%", content).replace("%name%", flag.getName()));
                        continue;
                    }
                    parsedArguments.addFlag(flag, parsed);
                    continue;
                }
                parsedArguments.addFlag(flag, new ParsedArgument<Boolean>(true));
            }
        }
        return this.execute(context, parsedArguments);
    }

    @Override
    @NotNull
    public List<String> getTab(@NotNull TabContext context) {
        if (this.isPlayerOnly() && context.getPlayer() == null) {
            return Collections.emptyList();
        }
        int firstArgIndex = context.getLastCommandIndex();
        int tabLength = context.length();
        int argIndex = 0;
        List<String> samples = new ArrayList<String>();
        for (int tabIndex = firstArgIndex; tabIndex < tabLength; ++tabIndex) {
            boolean lastIndex;
            String tabValue = context.getArg(tabIndex);
            boolean bl = lastIndex = tabIndex == tabLength - 1;
            if (argIndex >= this.arguments.size()) {
                Object lastArgument;
                if (!this.arguments.isEmpty() && ((CommandArgument)(lastArgument = this.arguments.getLast())).isComplex()) {
                    if (lastIndex) {
                        samples = this.getArgumentSamples((CommandArgument<?>)lastArgument, context);
                    }
                    context.appendArgumentCache((CommandArgument<?>)lastArgument, tabValue);
                }
                lastArgument = this.getFlags().iterator();
                while (lastArgument.hasNext()) {
                    CommandFlag commandFlag = (CommandFlag)lastArgument.next();
                    if (context.hasCachedFlag(commandFlag) || !commandFlag.hasPermission(context.getSender())) continue;
                    if (lastIndex) {
                        if (commandFlag instanceof ContentFlag) {
                            ContentFlag contentFlag = (ContentFlag)commandFlag;
                            samples = Lists.newList((Object[])new String[]{contentFlag.getSampled()});
                        } else {
                            samples = Lists.newList((Object[])new String[]{commandFlag.getPrefixed()});
                        }
                    }
                    context.cacheFlag(commandFlag, tabValue);
                }
                continue;
            }
            CommandArgument<?> argument = this.arguments.get(argIndex++);
            context.cacheArgument(argument, tabValue);
            if (!lastIndex) continue;
            samples = this.getArgumentSamples(argument, context);
        }
        return samples;
    }

    private List<String> getArgumentSamples(@NotNull CommandArgument<?> argument, @NotNull TabContext context) {
        if (!argument.hasPermission(context.getSender())) {
            return Collections.emptyList();
        }
        return argument.getSamples(context);
    }

    @Override
    @NotNull
    public String getUsage() {
        StringBuilder labelBuilder = new StringBuilder();
        this.arguments.forEach(argument -> {
            if (!labelBuilder.isEmpty()) {
                labelBuilder.append(" ");
            }
            labelBuilder.append(argument.getLocalized());
        });
        StringBuilder flagBuilder = new StringBuilder();
        this.flags.values().forEach(commandFlag -> {
            if (!flagBuilder.isEmpty()) {
                flagBuilder.append(" ");
            }
            flagBuilder.append(commandFlag.getPrefixedFormatted());
        });
        if (!flagBuilder.isEmpty()) {
            labelBuilder.append(" ").append((CharSequence)flagBuilder);
        }
        return labelBuilder.toString();
    }

    @NotNull
    public List<CommandArgument<?>> getArguments() {
        return this.arguments;
    }

    @Nullable
    public CommandFlag getFlag(@NotNull String name) {
        return this.flags.get(name.toLowerCase());
    }

    @NotNull
    public Collection<CommandFlag> getFlags() {
        return this.flags.values();
    }
}

