/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.bridge.common;

import java.util.Objects;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.util.Strings;

public class NightKey {
    public static final char DELIMITER = ':';
    private final String namespace;
    private final String value;

    private NightKey(@NotNull String namespace, @NotNull String value) {
        if (!NightKey.parseableNamespace(namespace)) {
            throw new IllegalArgumentException("Invalid namespace: '" + namespace + "'");
        }
        if (!NightKey.parseableValue(value)) {
            throw new IllegalArgumentException("Invalid value: '" + value + "'");
        }
        this.namespace = namespace;
        this.value = value;
    }

    @NotNull
    public static NightKey key(@NotNull String string) {
        return NightKey.key(string, ':');
    }

    @NotNull
    public static NightKey key(@NotNull String string, char character) {
        int index = string.indexOf(character);
        String namespace = index >= 1 ? string.substring(0, index) : "minecraft";
        String value = index >= 0 ? string.substring(index + 1) : string;
        String namespaceFiltered = (String)Strings.varStyle((String)namespace, NightKey::allowedInNamespace).orElseThrow(() -> new IllegalStateException("Invalid namespace: " + namespace));
        String valueFiltered = (String)Strings.varStyle((String)value, NightKey::allowedInValue).orElseThrow(() -> new IllegalStateException("Invalid value: " + value));
        return NightKey.key(namespaceFiltered, valueFiltered);
    }

    @NotNull
    public static NightKey key(@NotNull String namespace, @NotNull String value) {
        return new NightKey(namespace, value);
    }

    @Deprecated
    @NotNull
    public static NightKey fromString(@NotNull String string) {
        return NightKey.key(string);
    }

    @NotNull
    public static NightKey fromBukkit(@NotNull NamespacedKey key) {
        return new NightKey(key.getNamespace(), key.getKey());
    }

    public static boolean parseable(@NotNull String string) {
        int index = string.indexOf(58);
        String namespace = index >= 1 ? string.substring(0, index) : "minecraft";
        String value = index >= 0 ? string.substring(index + 1) : string;
        return NightKey.parseableNamespace(namespace) && NightKey.parseableValue(value);
    }

    public static boolean parseableNamespace(@NotNull String namespace) {
        int length = namespace.length();
        for (int index = 0; index < length; ++index) {
            if (NightKey.allowedInNamespace(namespace.charAt(index))) continue;
            return false;
        }
        return true;
    }

    public static boolean parseableValue(@NotNull String value) {
        int length = value.length();
        for (int index = 0; index < length; ++index) {
            if (NightKey.allowedInValue(value.charAt(index))) continue;
            return false;
        }
        return true;
    }

    public static boolean allowedInNamespace(char character) {
        return character == '_' || character == '-' || character >= 'a' && character <= 'z' || character >= '0' && character <= '9' || character == '.';
    }

    public static boolean allowedInValue(char character) {
        return NightKey.allowedInNamespace(character) || character == '/';
    }

    @NotNull
    public String namespace() {
        return this.namespace;
    }

    @NotNull
    public String value() {
        return this.value;
    }

    @NotNull
    public String asString() {
        return this.namespace + ":" + this.value;
    }

    @Deprecated
    @NotNull
    public NamespacedKey asBukkit() {
        return this.toBukkit();
    }

    @NotNull
    public NamespacedKey toBukkit() {
        return new NamespacedKey(this.namespace, this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof NightKey)) {
            return false;
        }
        NightKey nightKey = (NightKey)o;
        return Objects.equals(this.namespace, nightKey.namespace) && Objects.equals(this.value, nightKey.value);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.value);
    }
}

