/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.opening.inventory.spinner;

import java.util.List;
import org.bukkit.Sound;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.opening.inventory.spinner.SpinMode;
import su.nightexpress.excellentcrates.opening.inventory.spinner.SpinStep;
import su.nightexpress.excellentcrates.opening.inventory.spinner.SpinnerData;
import su.nightexpress.excellentcrates.opening.inventory.spinner.SpinnerHolder;
import su.nightexpress.excellentcrates.opening.inventory.spinner.SpinnerProvider;
import su.nightexpress.excellentcrates.opening.inventory.spinner.SpinnerType;
import su.nightexpress.nightcore.bridge.wrap.NightSound;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.sound.VanillaSound;

public class SpinnerBuilder {
    private SpinnerBuilder() {
    }

    @NotNull
    public static NameStep rewardBuilder() {
        return SpinnerBuilder.newBuilder(SpinnerType.REWARD);
    }

    @NotNull
    public static NameStep animationBuilder() {
        return SpinnerBuilder.newBuilder(SpinnerType.ANIMATION);
    }

    @NotNull
    public static NameStep newBuilder(@NotNull SpinnerType mode) {
        return new Steps(mode);
    }

    public static interface NameStep {
        @NotNull
        public ModeStep name(@NotNull String var1);
    }

    private static class Steps
    implements NameStep,
    ModeStep,
    SpinnerStep,
    SlotsStep,
    DelayStep,
    SpinsStep,
    ProviderStep,
    BuildStep {
        private final SpinnerType type;
        private String name;
        private SpinMode mode;
        private String spinnerId;
        private int[] slots;
        private int spinDelay;
        private List<SpinStep> spinSteps;
        private NightSound sound;
        private SpinnerProvider provider;

        private Steps(@NotNull SpinnerType type) {
            this.type = type;
            this.sound = null;
        }

        @Override
        @NotNull
        public BuildStep sound(@NotNull Sound sound) {
            this.sound = VanillaSound.of((Sound)sound, (float)0.8f, (float)1.0f);
            return this;
        }

        @Override
        @NotNull
        public ModeStep name(@NotNull String name) {
            this.name = name;
            return this;
        }

        @Override
        @NotNull
        public SpinnerStep mode(@NotNull SpinMode mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public SlotsStep spinnerId(@NotNull String spinnerId) {
            this.spinnerId = spinnerId;
            return this;
        }

        @Override
        @NotNull
        public SpinsStep delay(int spinDelay) {
            this.spinDelay = spinDelay;
            return this;
        }

        @Override
        @NotNull
        public DelayStep slots(int ... slots) {
            this.slots = slots;
            return this;
        }

        @Override
        @NotNull
        public ProviderStep steps(SpinStep ... steps) {
            this.spinSteps = Lists.newList((Object[])steps);
            return this;
        }

        @Override
        @NotNull
        public BuildStep provider(@NotNull SpinnerProvider provider) {
            this.provider = provider;
            return this;
        }

        @Override
        @NotNull
        public SpinnerHolder build() {
            SpinnerData data = new SpinnerData(this.spinnerId, this.mode, this.slots, this.spinDelay, this.spinSteps, this.sound);
            return new SpinnerHolder(this.name, this.type, data, this.provider);
        }
    }

    public static interface BuildStep {
        @NotNull
        public BuildStep sound(@NotNull Sound var1);

        @NotNull
        public SpinnerHolder build();
    }

    public static interface ProviderStep {
        @NotNull
        public BuildStep provider(@NotNull SpinnerProvider var1);
    }

    public static interface SpinsStep {
        @NotNull
        public ProviderStep steps(SpinStep ... var1);
    }

    public static interface DelayStep {
        @NotNull
        public SpinsStep delay(int var1);
    }

    public static interface SlotsStep {
        @NotNull
        public DelayStep slots(int ... var1);
    }

    public static interface SpinnerStep {
        public SlotsStep spinnerId(@NotNull String var1);
    }

    public static interface ModeStep {
        @NotNull
        public SpinnerStep mode(@NotNull SpinMode var1);
    }
}

