/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.opening;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.api.opening.Opening;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.crate.cost.Cost;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.impl.CrateSource;
import su.nightexpress.excellentcrates.data.crate.GlobalCrateData;
import su.nightexpress.excellentcrates.data.crate.UserCrateData;
import su.nightexpress.excellentcrates.user.CrateUser;
import su.nightexpress.nightcore.util.Players;

public abstract class AbstractOpening
implements Opening {
    protected final CratesPlugin plugin;
    protected final Player player;
    protected final CrateSource source;
    protected final Crate crate;
    protected final Cost cost;
    protected final List<Reward> rewards;
    protected long tickCount;
    protected boolean running;
    protected boolean refundable;

    public AbstractOpening(@NotNull CratesPlugin plugin, @NotNull Player player, @NotNull CrateSource source, @Nullable Cost cost) {
        this.plugin = plugin;
        this.player = player;
        this.source = source;
        this.crate = source.getCrate();
        this.cost = cost;
        this.rewards = new ArrayList<Reward>();
        this.setRefundable(true);
    }

    @Override
    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.onStart();
    }

    @Override
    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.onStop();
    }

    @Override
    public void tick() {
        if (!this.running) {
            return;
        }
        if (this.isCompleted()) {
            this.stop();
            return;
        }
        if (this.isTickTime()) {
            this.onTick();
        }
        this.tickCount = Math.max(0L, this.tickCount + 1L);
    }

    @Override
    public final boolean isRunning() {
        return this.running;
    }

    @Override
    public long getTickCount() {
        return this.tickCount;
    }

    @Override
    public boolean isTickTime() {
        return this.tickCount == 0L || this.tickCount % this.getInterval() == 0L;
    }

    protected abstract void onStart();

    protected abstract void onTick();

    protected abstract void onComplete();

    protected void onStop() {
        if (this.isRefundable()) {
            if (this.cost != null) {
                this.cost.refundAll(this.player);
            }
            if (this.source.getItem() != null) {
                Players.addItem((Player)this.player, (ItemStack[])new ItemStack[]{this.crate.getItemStack()});
            }
        }
        this.plugin.getOpeningManager().removeOpening(this.getPlayer());
        if (this.isCompleted()) {
            this.onComplete();
            CrateUser user = (CrateUser)this.plugin.getUserManager().getOrFetch(this.player);
            UserCrateData userData = user.getCrateData(this.crate);
            GlobalCrateData globalData = this.plugin.getDataManager().getCrateDataOrCreate(this.crate);
            userData.addOpenings(1);
            globalData.setLatestOpener(this.player);
            globalData.setSaveRequired(true);
            this.rewards.forEach(reward -> reward.give(this.player));
            if (this.crate.isOpeningCooldownEnabled() && !this.crate.hasCooldownBypassPermission(this.player)) {
                userData.setCooldown(this.crate.getOpeningCooldownTime());
            }
            if (this.crate.hasMilestones()) {
                userData.addMilestones(1);
                this.plugin.getCrateManager().triggerMilestones(this.player, this.crate, userData.getMilestone());
                if (userData.getMilestone() >= this.crate.getMaxMilestone() && this.crate.isMilestonesRepeatable()) {
                    userData.setMilestone(0);
                }
            }
            Lang.CRATE_REWARDS.message().send((CommandSender)this.player, replacer -> replacer.replace(this.crate.replacePlaceholders()).replace("%rewards%", (Object)this.rewards.stream().map(Reward::getName).collect(Collectors.joining(", "))));
            this.plugin.getUserManager().save(user);
        }
    }

    @Override
    @NotNull
    public List<Reward> getRewards() {
        return this.rewards;
    }

    @Override
    public void addReward(@NotNull Reward reward) {
        this.rewards.add(reward);
    }

    @Override
    public void addRewards(@NotNull Collection<Reward> rewards) {
        this.rewards.addAll(rewards);
    }

    @Override
    public boolean isRefundable() {
        return this.refundable;
    }

    @Override
    public void setRefundable(boolean refundable) {
        this.refundable = refundable;
    }

    @Override
    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @Override
    @NotNull
    public CrateSource getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public Crate getCrate() {
        return this.crate;
    }

    @Override
    @Nullable
    public Cost getCost() {
        return this.cost;
    }
}

