/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.crate.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.util.Lists;

public class OpenOptions {
    private final Set<Option> options;

    private OpenOptions(@NotNull Set<Option> options) {
        this.options = options;
    }

    @NotNull
    public static OpenOptions empty() {
        return new OpenOptions(new HashSet<Option>());
    }

    @NotNull
    public static OpenOptions of(Option ... options) {
        return new OpenOptions(Lists.newSet((Object[])options));
    }

    @NotNull
    public static OpenOptions ignoreRestrictions() {
        return OpenOptions.of(Option.IGNORE_COOLDOWN, Option.IGNORE_COST, Option.IGNORE_PERMISSION);
    }

    public boolean has(@NotNull Option option) {
        return this.options.contains((Object)option);
    }

    @NotNull
    public OpenOptions add(Option ... options) {
        this.options.addAll(Arrays.asList(options));
        return this;
    }

    @NotNull
    public OpenOptions remove(Option ... options) {
        Arrays.asList(options).forEach(this.options::remove);
        return this;
    }

    public static enum Option {
        IGNORE_COOLDOWN,
        IGNORE_COST,
        IGNORE_PERMISSION,
        IGNORE_ANIMATION;

    }
}

